Ext.data.JsonP.sol_common_ObjectFormatter({"tagname":"class","name":"sol.common.ObjectFormatter","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.ObjectFormatter.js","href":"lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter"}],"author":[{"tagname":"author","name":"Michael Weiler, ELO Digital Office GmbH","email":null}],"version":["1.0"],"eloix":true,"elojc":true,"eloas":true,"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"requires":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"format","tagname":"method","owner":"sol.common.ObjectFormatter","id":"method-format","meta":{"private":true}},{"name":"formatPart","tagname":"method","owner":"sol.common.ObjectFormatter","id":"method-formatPart","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.ObjectFormatter","short_doc":"This class helps in creating simplified instances of de.elo.ix.client.*-objects like Sord. ...","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.ObjectFormatter</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter' target='_blank'>lib_sol.common.ObjectFormatter.js</a></div></pre><div class='doc-contents'><p>This class helps in creating simplified instances of de.elo.ix.client.*-objects like <code>Sord</code>. Simplified objects are\nmostly used by <a href=\"#!/api/sol.common.Template\" rel=\"sol.common.Template\" class=\"docClass\">sol.common.Template</a> or sol.common.ix.functions.JsonDataCollector. Formatters are used by solutions if large\namounts of data are loaded from ELO or if properties needs to be accessible in templating environments.</p>\n\n<p>There are several formatter implementations for formatting objects e.g. <code><a href=\"#!/api/sol.common.ObjectFormatter.TemplateSord\" rel=\"sol.common.ObjectFormatter.TemplateSord\" class=\"docClass\">sol.common.ObjectFormatter.TemplateSord</a></code>.\nCore formatting operations like objKey filtering, etc. is done by a base class\ne.g. <code><a href=\"#!/api/sol.common.ObjectFormatter.BaseSord\" rel=\"sol.common.ObjectFormatter.BaseSord\" class=\"docClass\">sol.common.ObjectFormatter.BaseSord</a></code> which is the superclass of <code>TemplateSord</code> implementation.</p>\n\n<pre><code>var formattedObject = <a href=\"#!/api/sol.common.ObjectFormatter-method-format\" rel=\"sol.common.ObjectFormatter-method-format\" class=\"docClass\">sol.common.ObjectFormatter.format</a>({\n  sord: {\n    formatter: '<a href=\"#!/api/sol.common.ObjectFormatter\" rel=\"sol.common.ObjectFormatter\" class=\"docClass\">sol.common.ObjectFormatter</a>.{FORMATTER CLASS NAME}',\n    // original object returned by ix\n    data: {IX OBJECT},\n    config: {\n      // formatter configuration as defined by the formatters base class\n    }\n});\n</code></pre>\n\n<p>Following list of Base classes can be used in order to process <code>Sords</code>, <code>Tasks</code> and keyword lists.</p>\n\n<ul>\n<li><a href=\"#!/api/sol.common.ObjectFormatter.BaseSord\" rel=\"sol.common.ObjectFormatter.BaseSord\" class=\"docClass\">sol.common.ObjectFormatter.BaseSord</a></li>\n<li><a href=\"#!/api/sol.common.ObjectFormatter.BaseTask\" rel=\"sol.common.ObjectFormatter.BaseTask\" class=\"docClass\">sol.common.ObjectFormatter.BaseTask</a></li>\n</ul>\n\n\n<h1>Example usage by templates</h1>\n\n<p>Templates can't access objKeys stored in array values in an easy way.</p>\n\n<pre><code>var data = <a href=\"#!/api/sol.common.ObjectFormatter-method-format\" rel=\"sol.common.ObjectFormatter-method-format\" class=\"docClass\">sol.common.ObjectFormatter.format</a>({\n  sord: {\n    formatter: '<a href=\"#!/api/sol.common.ObjectFormatter.TemplateSord\" rel=\"sol.common.ObjectFormatter.TemplateSord\" class=\"docClass\">sol.common.ObjectFormatter.TemplateSord</a>',\n    // instance of de.elo.ix.client.Sord\n    data: sord\n  }\n});\n</code></pre>\n\n<p>The transformed object results as followed.</p>\n\n<pre><code>data = {\n  \"id\": \"7572\",\n  \"maskName\": \"Incoming invoice\",\n  \"name\": \"Invoice 0000\",\n  \"IDateIso\": \"20150720142400\",\n  \"XDateIso\": \"\",\n  \"objKeys\": {\n    \"VENDOR_NAME\": \"Weiler KG\",\n    \"INVOICE_DATE\": \"20150601162415\",\n    \"INVOICE_CASH_DISCOUNT_AMOUNT\": 554\n  }\n}\n</code></pre>\n\n<h1>Example usage for statistical processing</h1>\n\n<p>If working with large amounts of data it is mandatory to define the properties required for the data analys in order\nto reduce the amount of data loaded from the client. IndexServer Sord-Objects contain a lot of information that might\nnot be required for the analysis. <a href=\"#!/api/sol.common.ObjectFormatter.StatisticSord\" rel=\"sol.common.ObjectFormatter.StatisticSord\" class=\"docClass\">sol.common.ObjectFormatter.StatisticSord</a> allows defining the sord keys, objKeys,\n... information that is required.</p>\n\n<p>Please note that using map keys is more expensive than storing values in objKeys since accessing these values requires\nadditional ix checkout calls. Furthermore objKeys can be converted to numeric values automatically.</p>\n\n<p>This functionality is used by services while collecting data for dashboard apps\ndeveloped in angular js.</p>\n\n<pre><code>var data = <a href=\"#!/api/sol.common.ObjectFormatter-method-format\" rel=\"sol.common.ObjectFormatter-method-format\" class=\"docClass\">sol.common.ObjectFormatter.format</a>({\n  sord: {\n    formatter: '<a href=\"#!/api/sol.common.ObjectFormatter.StatisticSord\" rel=\"sol.common.ObjectFormatter.StatisticSord\" class=\"docClass\">sol.common.ObjectFormatter.StatisticSord</a>',\n    // instance of de.elo.ix.client.Sord\n    data: sord,\n    config: {\n      sordKeys: ['id', 'maskName', 'name', 'IDateIso', 'XDateIso'],\n      objKeys: ['VENDOR_NAME', 'INVOICE_DATE', 'INVOICE_CASH_DISCOUNT_AMOUNT']\n    }\n});\n</code></pre>\n\n<p>The transformed object results as followed.</p>\n\n<pre><code>data = {\n  \"id\": \"7572\",\n  \"maskName\": \"Incoming invoice\",\n  \"name\": \"Invoice 0000\",\n  \"IDateIso\": \"20150720142400\",\n  \"XDateIso\": \"\",\n  \"O_VENDOR_NAME\": \"Weiler KG\",\n  \"O_INVOICE_DATE\": \"20150601162415\",\n  \"O_INVOICE_CASH_DISCOUNT_AMOUNT\": 554,\n}\n</code></pre>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-format' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ObjectFormatter'>sol.common.ObjectFormatter</span><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-method-format' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter-method-format' class='name expandable'>format</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-formatPart' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ObjectFormatter'>sol.common.ObjectFormatter</span><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-method-formatPart' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter-method-formatPart' class='name expandable'>formatPart</a>( <span class='pre'>partName, configPart, result</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>partName</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>configPart</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>result</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true,"eloix":true,"elojc":true,"singleton":true}});